const jwt = require("jsonwebtoken");
const MultiCurrency = require("../models/currencyModel");
const User = require("../models/userModel");
const moment = require("moment/moment");

const verification = async (token) => {
  try {
    // if (token.startsWith("Bearer ")) {
    //   TokenArray = token.split(" ");
    //   const decoded = jwt.verify(TokenArray[1], process.env.JWT_SECRET);
    //   const user = await User.findOne({ _id: decoded.id });
    //   if (user !== null && decoded.exp > Date.now() / 1000) {
    //     return true;
    //   } else {
    //     return false;
    //   }
    // } else {
    //   return false;
    // }
    return true;
  } catch (error) {
    return false;
  }
};

exports.getMultiCurrency = async (req, res, next) => {
  const isVerified = await verification(req.headers["authorization"]);
  if (isVerified) {
    const multiCurrency = await MultiCurrency.find({ IsDelete: false });
    res.setHeader("Content-Type", "application/javascript");
    res.status(200).send({
      message: "",
      IsSuccess: true,
      Status_Code: 200,
      Data: multiCurrency,
    });
  } else {
    res.setHeader("Content-Type", "application/javascript");
    res.status(401).send({
      message: "Unauthorized access! Please Login again.",
      IsSuccess: false,
      Status_Code: 401,
      Data: null,
    });
  }
};

exports.getMultiCurrencyDropdown = async (req, res, next) => {
  const isVerified = await verification(req.headers["authorization"]);
  if (true) {
    const products = await MultiCurrency.find(
      { IsDelete: false }, // Query criteria
      { code: 1, _id: 1, exchangeRate: 1 } // Projection to include only name and _id fields
    );
    res.setHeader("Content-Type", "application/javascript");
    res.status(200).send({
      message: "",
      IsSuccess: true,
      Status_Code: 200,
      Data: products,
    });
  } else {
    res.setHeader("Content-Type", "application/javascript");
    res.status(401).send({
      message: "Unauthorized access! Please Login again.",
      IsSuccess: false,
      Status_Code: 401,
      Data: null,
    });
  }
};

exports.saveMultiCurrency = async (req, res, next) => {
  const isVerified = await verification(req.headers["authorization"]);
  if (isVerified) {
    const body = req.body;
    const data = {
      name: body.name,
      code: body.code,
      exchangeRate: body.exchangeRate,
      decimalPoints: body.decimalPoints,
      IsActive: body.IsActive,
      IsDelete: false,
      CreatedBy: body.User,
      CreatedOn: moment().format("YYYY-MMM-DD"),
    };
    const newMultiCurrency = await MultiCurrency.create(data);
    res.json({
      message: "New MultiCurrency created successfully.",
      IsSuccess: true,
      Status_Code: 200,
      Data: newMultiCurrency,
    });
  } else {
    res.setHeader("Content-Type", "application/javascript");
    res.status(401).send({
      message: "Unauthorized access! Please Login again.",
      IsSuccess: false,
      Status_Code: 401,
      Data: null,
    });
  }
};

exports.editMultiCurrency = async (req, res, next) => {
  const isVerified = await verification(req.headers["authorization"]);
  if (isVerified) {
    const body = req.body;
    const updateMultiCurrency = await MultiCurrency.updateOne(
      { _id: body._id },
      {
        $set: {
          name: body.name,
          code: body.code,
          exchangeRate: body.exchangeRate,
          decimalPoints: body.decimalPoints,
          IsActive: body.IsActive,
          ModifiedBy: body.User,
          ModifiedOn: moment().format("YYYY-MMM-DD"),
        },
      }
    );
    const updatedMultiCurrency = await MultiCurrency.findById(body._id);
    res.json({
      message: "MultiCurrency updated successfully.",
      IsSuccess: true,
      Status_Code: 200,
      Data: updatedMultiCurrency,
    });
  } else {
    res.setHeader("Content-Type", "application/javascript");
    res.status(401).send({
      message: "Unauthorized access! Please Login again.",
      IsSuccess: false,
      Status_Code: 401,
      Data: null,
    });
  }
};

exports.deleteMultiCurrency = async (req, res, next) => {
  const isVerified = await verification(req.headers["authorization"]);
  if (isVerified) {
    const body = req.body;
    const updateMultiCurrency = await MultiCurrency.updateOne(
      { _id: body._id },
      {
        $set: {
          IsActive: body.IsActive,
          IsDelete: body.IsDelete,
          ModifiedBy: body.User,
          ModifiedOn: moment().format("YYYY-MMM-DD"),
        },
      }
    );
    const updatedMultiCurrency = await MultiCurrency.findOne({
      _id: body._id,
    });
    res.json({
      message: "MultiCurrency deleted successfully.",
      IsSuccess: true,
      Status_Code: 200,
      Data: updatedMultiCurrency,
    });
  } else {
    res.setHeader("Content-Type", "application/javascript");
    res.status(401).send({
      message: "Unauthorized access! Please Login again.",
      IsSuccess: false,
      Status_Code: 401,
      Data: null,
    });
  }
};
