const express = require("express");
const authController = require("../controllers/authController");
const userController = require("../controllers/userController");

const router = express.Router();

router.get("/api/Get_Users", userController.getUsers);
router.get("/api/Get_Users_Dropdown", userController.getUsersDropdown);
router.post("/api/Save_User", userController.saveUser);
router.post("/api/Edit_User", userController.editUser);
router.post("/api/Delete_User", userController.deleteUser);
router.post("/api/updateUser", userController.updateUser);
router.post("/api/Change_User_Status", userController.changeUserStatus);

router.post("/api/signup", authController.signUp);
router.post("/api/signin", authController.signin);
router.post("/api/appSignin", authController.appSignin);
router.post("/api/forget_password", authController.forgetPassword);
router.post("/api/change_password", authController.changePassword);

module.exports = router;
