const express = require("express");
const PushNotificationsController = require("../controllers/pushNotificationsController");

const router = express.Router();

router.get(
  "/api/Get_PushNotifications",
  PushNotificationsController.getPushNotifications
);

router.get(
  "/api/Get_PushNotifications_By_UserID=:id",
  PushNotificationsController.getPushNotificationsByUserId
);
router.post(
  "/api/Save_PushNotification",
  PushNotificationsController.savePushNotification
);
router.post(
  "/api/Edit_PushNotification",
  PushNotificationsController.editPushNotification
);
router.get(
  "/api/Mark_Notifications_AsRead=:id",
  PushNotificationsController.markAsRead
);
router.post(
  "/api/Delete_PushNotification",
  PushNotificationsController.deletePushNotification
);

module.exports = router;
