const express = require("express");
const OrdersController = require("../controllers/ordersController");

const router = express.Router();

router.get("/api/Get_Orders", OrdersController.getOrders);
router.get(
  "/api/Get_Order_By_UserID=:id",
  OrdersController.Get_Order_By_UserID
);
router.post("/api/Save_Order", OrdersController.saveOrder);
router.post("/api/Edit_Order", OrdersController.editOrder);
router.post("/api/Delete_Order", OrdersController.deleteOrder);

module.exports = router;
