const express = require("express");
const cors = require("cors");
const bodyParser = require("body-parser");

const userRoutes = require("./routes/userRoutes.js");
const campaignsRoutes = require("./routes/campaignsRoutes.js");
const campaignCategoriesRoutes = require("./routes/campaignCategoriesRoutes.js");
const couponsRoutes = require("./routes/couponsRoutes.js");
const drawsRoutes = require("./routes/drawsRoutes.js");
const multiCurrencyRoutes = require("./routes/multiCurrencyRoutes.js");
const ordersRoutes = require("./routes/ordersRoutes.js");
const prizeRoutes = require("./routes/prizeRoutes.js");
const productsRoutes = require("./routes/productsRoutes.js");
const pushNotificationsRoutes = require("./routes/pushNotificationsRoutes.js");
const shippingChargesRoutes = require("./routes/shippingChargesRoutes.js");
const winnersRoutes = require("./routes/winnersRoutes.js");
const homeBannerRoutes = require("./routes/homeBanner.js");
const ticketsRoutes = require("./routes/ticketsRoutes.js");
const checkoutRoutes = require("./routes/checkoutRoutes.js");

const app = express();
app.use(express.json({ limit: "10mb" }));
app.use(express.urlencoded({ extended: true, limit: "10kb" }));
// Serve static files from the "assets" directory
app.use("/assets", express.static("assets"));

app.use("/", (req, res, next) => {
  console.log(req.url);
  console.log(req.headers.host);
  next();
});

//allow specific users
app.use(cors());
app.use("/", userRoutes);
app.use("/", campaignsRoutes);
app.use("/", campaignCategoriesRoutes);
app.use("/", couponsRoutes);
app.use("/", drawsRoutes);
app.use("/", multiCurrencyRoutes);
app.use("/", ordersRoutes);
app.use("/", prizeRoutes);
app.use("/", productsRoutes);
app.use("/", pushNotificationsRoutes);
app.use("/", shippingChargesRoutes);
app.use("/", winnersRoutes);
app.use("/", homeBannerRoutes);
app.use("/", ticketsRoutes);
app.use("/", checkoutRoutes);

app.use("/", (req, res, next) => {
  console.log(req.url);
  next();
});

app.use("/assets/uploads", (req, res, next) => {
  console.log("image request");
  next();
});

// app.all("*", (req, res, next) => {
//   res.status(404).json({
//     message: "URL not found.",
//     IsSuccess: false,
//     Status_Code: 404,
//     Data: null,
//   });
// });

//SERVER
module.exports = app;
